IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[INTEGRA_BENNER_DADOSPIX]') AND type in (N'U'))
BEGIN

	CREATE TABLE [dbo].[INTEGRA_BENNER_DADOSPIX](
		[ID] uniqueidentifier NOT NULL DEFAULT (newid()),
		[CD_EMP] int NOT NULL,
		[CD_FILIAL] int NOT NULL,
		[CD_CNT] int NOT NULL,
		[CD_BC] int NOT NULL,
		[AGENCIA] int NOT NULL,
		[NUMERO] int NOT NULL,
		[DV] int NOT NULL,
		[DT_CADASTRO] DATETIME DEFAULT (GETDATE()) NULL,
	 CONSTRAINT [PK_INTEGRA_BENNER_DADOSPIX] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX]  WITH CHECK ADD  CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_BC_BANCO] FOREIGN KEY([CD_EMP], [CD_BC])
	REFERENCES [dbo].[BC_BANCO] ([CD_EMP], [CD_BC])

	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX] CHECK CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_BC_BANCO]

	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX]  WITH CHECK ADD  CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_BC_CONTAS] FOREIGN KEY([CD_EMP], [CD_CNT])
	REFERENCES [dbo].[BC_CONTAS] ([CD_EMP], [CD_CNT])

	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX] CHECK CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_BC_CONTAS]

	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX]  WITH CHECK ADD  CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_PRC_EMP] FOREIGN KEY([CD_EMP])
	REFERENCES [dbo].[PRC_EMP] ([CD_EMP])

	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX] CHECK CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_PRC_EMP]

	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX]  WITH CHECK ADD  CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
	REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])

	ALTER TABLE [dbo].[INTEGRA_BENNER_DADOSPIX] CHECK CONSTRAINT [FK_INTEGRA_BENNER_DADOSPIX_PRC_FILIAL]

END